/* DO NOT EDIT THIS FILE */
/* This file is autogenerated by the text-database code generator */

#ifndef TOUCHGFX_UNMAPPEDDATAFONT_HPP
#define TOUCHGFX_UNMAPPEDDATAFONT_HPP

#include <touchgfx/Font.hpp>

namespace touchgfx
{
/**
 * An UnmappedDataFont has both glyph table and glyph data placed in a
 * flash which does not support random access read (indirect
 * access). A unicode table is located in a flash with random read
 * access (direct access).
 *
 * @see Font, ConstFont
 */
class UnmappedDataFont : public Font
{
public:
    /**
     * Construct the UnmappedDataFont.
     *
     * @param glyphs                 The array of glyphs known to this font (indirect).
     * @param unicodes               The array of unicodes known to this font (direct).
     * @param numGlyphs              The number of glyphs in list.
     * @param height                 The height in pixels of the highest character in this font.
     * @param baseline               The height of the baseline in pixels.
     * @param pixBelowBottom         The maximum number of pixels that can be drawn below the
     *                               bottom in this font.
     * @param bitsPerPixel           The number of bits per pixel in this font.
     * @param byteAlignRow           Are glyphs encoded using A4 format
     * @param maxLeft                The maximum a character extends to the left.
     * @param maxRight               The maximum a character extends to the right.
     * @param glyphDataList          Pointer to pointers the glyph data for the font (indirect).
     * @param kerningList            pointer to the kerning data for the font (direct).
     * @param fallbackChar           The fallback character for the typography in case no glyph is
     *                               available.
     * @param ellipsisChar           The ellipsis character used for truncating long texts.
     * @param gsubTable              Pointer to GSUB table (direct).
     */
    UnmappedDataFont(const GlyphNode* glyphs, const uint16_t* unicodes, uint16_t numGlyphs, uint16_t height, uint16_t baseline, uint8_t pixAboveTop, uint8_t pixBelowBottom, uint8_t bitsPerPixel, uint8_t byteAlignRow, uint8_t maxLeft, uint8_t maxRight, const uint8_t* const* glyphDataList, const KerningNode* kerningList, const Unicode::UnicodeChar fallbackChar, const Unicode::UnicodeChar ellipsisChar, const uint16_t* const gsubData, const FontContextualFormsTable* formsTable);

    using Font::getGlyph;

    /**
     * Gets the glyph data associated with the specified Unicode. The
       GlyphNode is allocated in the buffer passed to the constructor.
     *
     * Please note that in case of Thai letters and Arabic letters
     * where diacritics can be placed relative to the previous
     * character(s), please use TextProvider::getNextLigature()
     * instead as it will create a temporary GlyphNode that will be
     * adjusted with respect to X/Y position.
     *
     * @param       unicode      The character to look up.
     * @param       pixelData    Pointer to the pixel data for the glyph if the glyph is
     *                           found. This is set by this method.
     * @param [out] bitsPerPixel Reference where to place the number of bits per pixel.
     *
     * @return A pointer to the glyph node or null if the glyph was not found.
     */
    virtual const GlyphNode* getGlyph(Unicode::UnicodeChar unicode, const uint8_t*& pixelData, uint8_t& bitsPerPixel) const;

    /**
     * Obtains the address to the pixel data for the specified glyph.
     *
     * @param glyph The glyph to get the pixels data of.
     *
     * @return The address of the pixel data of the glyph.
     */
    virtual const uint8_t* getPixelData(const GlyphNode* glyph) const;

    /**
     * Gets the kerning distance between two characters.
     *
     * @param prevChar The unicode value of the previous character.
     * @param glyph    the glyph object for the current character.
     *
     * @return The kerning distance between prevChar and glyph char.
     */
    virtual int8_t getKerning(Unicode::UnicodeChar prevChar, const GlyphNode* glyph) const;

    /**
     * Gets GSUB table.
     *
     * @return The GSUB table or null if font has GSUB no table
     */
    virtual const uint16_t* getGSUBTable() const
    {
        return gsubTable;
    }

    /**
     * Gets the contextual forms table used in arabic fonts.
     *
     * @return The FontContextualFormsTable or null if the font has no table.
     */
    virtual const FontContextualFormsTable* getContextualFormsTable() const
    {
        return arabicTable;
    }

protected:
    UnmappedDataFont()
        : Font(0, 0, 0, 0, 0, 0, 0, 0, 0, 0), glyphList(0), unicodes(0), glyphDataList(0), kerningData(0), gsubTable(0)
    {
    }

    int lookupUnicode(uint16_t unicode) const;

    const GlyphNode* glyphList;     ///< The list of glyphs
    uint16_t listSize;              ///< The size of the list of glyphs
    const uint16_t* unicodes;       ///< LookupTable with all unicodes in this font
    const void* glyphDataList;      ///< The glyphs (list of pointers)
    const KerningNode* kerningData; ///< The kerning
    const uint16_t* gsubTable;      ///< The GSUB tables

    const FontContextualFormsTable* arabicTable; ///< Contextual forms

    static GlyphNode glyphNodeBuffer; ///< Buffer for GlyphNodes read from unmapped flash
};

class CompressedUnmappedDataFont : public UnmappedDataFont
{
public:
    CompressedUnmappedDataFont(const GlyphNode* glyphs, const uint16_t* unicodes, uint16_t numGlyphs, uint16_t height, uint16_t baseline, uint8_t pixAboveTop, uint8_t pixBelowBottom, uint8_t bitsPerPixel, uint8_t byteAlignRow, uint8_t maxLeft, uint8_t maxRight, const uint8_t* const* glyphDataList, const KerningNode* kerningList, const Unicode::UnicodeChar fallbackChar, const Unicode::UnicodeChar ellipsisChar, const uint16_t* const gsubData, const FontContextualFormsTable* formsTable);

    virtual const GlyphNode* getGlyph(Unicode::UnicodeChar unicode) const;
    virtual const GlyphNode* getGlyph(Unicode::UnicodeChar unicode, const uint8_t*& pixelData, uint8_t& bitsPerPixel) const;
    virtual const uint8_t* getPixelData(const GlyphNode* glyph) const;
};

} // namespace touchgfx

#endif // TOUCHGFX_UNMAPPEDDATAFONT_HPP
